/*
 *  GeometryUtils.cpp
 *  openFrameworks
 *
 *  Created by Josh Nimoy on 11/15/09.
 *  Copyright 2009 Josh Nimoy. All rights reserved.
 *
 */

#include "GeometryUtils.h"


/**
	this code was taken from virtual origami icm final from itp
	dumbed down only to return true or false, instead of a 
	full geometric relationships report.
 
	warning: Z not implemented
*/

#define CMPPNTS(a,b,c,d) ((a==c)&&(b==d))

bool GeometryUtils::segmentsIntersect(float x1,float y1,
					  float x2,float y2,
					  float x3,float y3,
					  float x4,float y4){
    float ix=0;
    float iy=0;
    float m1=0;
    float m2=0;
    float b1=0;
    float b2=0;
    
    if(CMPPNTS(x1,y1,x3,y3)||CMPPNTS(x1,y1,x4,y4)||
       CMPPNTS(x2,y2,x3,y3)||CMPPNTS(x2,y2,x4,y4)){
		//any vertexes have a straight match?
		return true;
    }
    
    //vertical check
    if(x1==x2){//vertical solutions
		m2 = (y3 - y4)/(x3 - x4);
		b2 = y3 - m2 * x3;
		ix = x1;
		iy = m2*x1 + b2;
		
    }else if(x3==x4){//vertical solutions
		m1 = (y1 - y2)/(x1 - x2);
		b1 = y1 - m1 * x1;
		ix = x3;
		iy = m1*x3 + b1;
		
    }else{//otherwise, do it like you would
		// slopes
		m1 = (y1 - y2)/(x1 - x2);
		m2 = (y3 - y4)/(x3 - x4);
		
		if(m1==m2){
			//ir.parallel = true;
			//return ir;
			return false;
		}
		// y-intercepts
		b1 = y1 - m1 * x1;
		b2 = y3 - m2 * x3;
		
		ix = (b1-b2)/(m2-m1);
		iy = m1*ix + b1;
    }
    
    //and finally, check to see if it is within both segments.
    //first, the Xs
    
    if(x1>x2){
		if(ix > x1 || ix < x2)return false;//ir.outside = true;
    }else{
		if(ix < x1 || ix > x2)return false;//ir.outside = true;
    }
    
    if(x3>x4){
		if(ix > x3 || ix < x4)return false;//ir.outside = true;
    }else{
		if(ix < x3 || ix > x4)return false;//ir.outside = true;
    }
    
    //then the Y's
    
    if(y1>y2){
		if(iy > y1 || iy < y2)return false;//ir.outside = true;
    }else{
		if(iy < y1 || iy > y2)return false;//ir.outside = true;
    }
    
    if(y3>y4){
		if(iy > y3 || iy < y4)return false;//ir.outside = true;
    }else{
		if(iy < y3 || iy > y4)return false;//ir.outside = true;
    }
    
    //  if(ir.outside){
    // return false;
    //return ir;
    // }else{
    //ir.ok = true;
    return true;
    //return ir;
    //}
}


//--------------------------------------------------------------------------



void GeometryUtils::findLinesIntersection(float x0,float y0,
										  float x1,float y1,
										  float x2,float y2,
										  float x3,float y3,
										  float &xi,float &yi){
    //THANK YOU PETE CONOLLY
    float infinity_approx = 999999999999999999999.0f;
    float a1=0.0;
    float b1=0.0;
    float c1=0.0; // constants of linear equations
    float a2=0.0;
    float b2=0.0;
    float c2=0.0;
    float det_inv=0.0;  // the inverse of the determinant of the coefficient
    float m1=0.0;
    float m2=0.0;    // the slopes of each line
    
    if(x1!=x0)m1=(y1-y0)/(x1-x0);
    else m1 = infinity_approx;
    
    if(x3!=x2)m2=(y3-y2)/(x3-x2);
    else m2 = infinity_approx;
    a1=m1;
    a2=m2;
    b1=-1;
    b2=-1;
    c1=(y0-m1*x0);
    c2=(y2-m2*x2);
    // compute the inverse of the determinate
    det_inv = 1/(a1*b2 - a2*b1);
    // use Kramers rule to compute xi and yi
    xi=((b1*c2 - b2*c1)*det_inv);
    yi=((a2*c1 - a1*c2)*det_inv);
}

